dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 8, 190, 400, "assets/images/table/cruise_8", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 2, 3, 300, 250, "assets/images/table/cruise", "assets/images/food/item_mark1", "R" );

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 2;
numServers = 1;

maxCoupleHappiness = 200;

-- Group 1

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);


-- Group 2


guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 7, 20000);

-- Group 3

guest = LManager.GenGuest(male04);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(8, 9, 38000);


guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 11, 55000);

-- Group 3


guest = LManager.GenGuest(male01);
guest.matchType = table1;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestTissue = 40;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(12, 13, 70000);


guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table1;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(14, 15, 100000);


-- Group 4

guest = LManager.GenGuest(female02);
guest.matchType = table2;
guest.percentRequestDrink = 80;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = table2;
guest.percentRequestCoffee = 20;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(16, 18, 120000);

-- Group 5

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(19, 20, 140000);

-- Group 6

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(21, 22, 152000);



LManager:AdjustGuestTolerance(130);

LManager:SetLevelSetting ("dogDelay", 130000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("speakerDelay", 80000); 
LManager:SetLevelSetting ("speakerChance", 30);

-- Set up the Level Settings
LManager:SetLevelNumber(3,9);
LManager:SetLevelScores(8600, 12000);
LManager:SetLevelTime(300000);

LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 1.ogg","assets/audio/music/new_dance_3.ogg","assets/audio/music/new_dance_4.ogg");
LManager:SetBackgroundImage("assets/images/bg_cruise");
LManager:SetChairImage("assets/images/table/chair03");


-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );